export class BitSet {
  #data = 0n;

  constructor(elems = []) {
    for (const elem of elems) {
      this.add(elem);
    }
  }

  add(elem) {
    checkElem(elem);
    this.#data = this.#data | (1n << elem);
    return this;
  }

  delete(elem) {
    checkElem(elem);
    if (this.has(elem)) {
      this.#data = this.#data ^ (1n << elem);
    }
    return this;
  }

  has(elem) {
    checkElem(elem);
    return (this.#data & (1n << elem)) !== 0n;
  }

  * [Symbol.iterator]() {
    let curElem = 0n;
    let bitMask = 1n;
    while (true) {
      if (bitMask > this.#data) {
        return;
      }
      if (this.#data & bitMask) {
        yield curElem;
      }
      curElem++;
      bitMask = bitMask << 1n;
    }
  }

  values() {
    return this[Symbol.iterator]();
  }
}

function checkElem(elem) {
  if (typeof elem !== 'bigint') {
    throw new TypeError('Element must be bigint: ' + elem);
  }
  if (elem < 0) {
    throw new RangeError('Element must be zero or greater: ' + elem);
  }
}